var samplePageObj = {
  // 샘플 타이틀
  title: '페이징',
  subtitle: '다양한 페이징 방법을 소개합니다.',
  // 샘플 설명
  desc: '1. 전체 데이터를 모두 클라이언트에 가져온 후, 데이터를 나누어 페이지 형식으로 보여주는 <b>클라이언트 페이징</b> (SearchMode:1)<br>'
    + '2. 전통적인 페이징 인덱스 방식과 유사한 형식의 <b>서버 페이징</b>(SearchMode:4)<br>'
    + '3. 세로 스크롤바를 최하단으로 내릴때 마다 다음 데이터를 기존데이터 뒤에 append하는 형식의 <b>서버스크롤페이징</b>(SearchMode:3)<br>'
    + '페이지네비게이션은 클라이언트/서버 페이징에서만 동작합니다.',

  // jquery 플러그인
  externalScript: ['https://www.ibsheet.com/v7/libs/pagination/jquery.twbsPagination.min.js'],

  // jquery 플러그인에서 사용될 css
  internalStyles: '.pagination { display: inline-block; padding-left: 0; margin: 20px 0; border-radius: 4px;}.pagination>li { display: inline-block;}.pagination>li>a:focus, .pagination>li>a:hover, .pagination>li>span:focus, .pagination>li>span:hover { z-index: 2; color: #23527c; background-color: #eee; border-color: #ddd;}.pagination-sm>li>a, .pagination-sm>li>span { padding: 5px 10px; font-size: 12px; line-height: 1.5;}.pagination>li>a, .pagination>li>span { position: relative; float: left; padding: 6px 12px; margin-left: -1px; line-height: 1.42857143; color: #337ab7; text-decoration: none;background-color: #fff; border: 1px solid #ddd;} .pagination>.active>a, .pagination>.active>a:focus, .pagination>.active>a:hover, .pagination>.active>span, .pagination>.active>span:focus, .pagination>.active>span:hover { z-index: 3; color: #fff; cursor: default; background-color: #337ab7; border-color: #337ab7;}',
  // 객체 초기화 구문
  init: {
    Def: {
      Header: {},
      Row: {},
      Col: { Width: '120' }
    },
    Cfg: {
      SearchMode: 1,
      PageLength: 50,
      Alternate: 2,
      InfoRowConfig: ''
    },
    LeftCols: [
      {
        Header: 'No',
        Name: 'SEQ',
        Width: '90'
      }
    ],
    Cols: [
      {
        Header: '확인',
        Type: 'Bool',
        Name: 'sCheck',
        Width: '60'
      },
      {
        Header: '회사',
        Type: 'Text',
        Name: 'sCompany',
        Width: '150'
      },
      {
        Header: '판매 국가',
        Type: 'Text',
        Name: 'sCountry'
      },
      {
        Header: '판매 수량',
        Type: 'Int',
        Name: 'sSaleQuantity'
      },
      {
        Header: '판매 증가량',
        Type: 'Int',
        Name: 'sSaleIncrease'
      },
      {
        Header: '가격',
        Type: 'Int',
        Name: 'sPrice',
        Format: '#,### \\원',
        Width: '180'
      },
      {
        Header: '만족도',
        Type: 'Int',
        Name: 'sSatisfaction',
        Format: '# \\%'
      },
      {
        Header: '코멘트',
        Type: 'Text',
        Name: 'sComment',
        Width: '300',
        RelWidth: 1
      },
    ],
  },

  // 버튼/기능 영역 html (sampleBtn으로 호출하면 action함수로 연결)
  func: '<div><input type=\'checkbox\' id=\'chk1\' onclick=\'sampleBtn(this)\'> <label class=\'mgr10\'>페이지네비게이션 표시</label><hr>'
    + '<input type=\'checkbox\' id=\'chk2\' onclick=\'sampleBtn(this)\'> <label class=\'mgr10\'>JQuery 네비게이션 표시</label><hr>'
    + '<button class=\'mgr10\' onclick=\'sampleBtn(this, 1)\'>클라이언트페이징</button><hr>'
    + '<button class=\'mgr10\' onclick=\'sampleBtn(this, 4)\'>서버페이징</button><hr>'
    + '<button class=\'mgr10\' onclick=\'sampleBtn(this, 3)\'>서버스크롤페이징</button></div>',

  // 객체 생성 Html
  objEl: '<div id=\'sheetDiv\' style=\'width:100%;height:90%\'></div><input type=\'hidden\' name=\'pagenum\' id=\'pagenum\' value=\'1\'><div id=\'pageNavi\' style=\'width:100%;height:100px;align:center;display:none;\'></div>',

  // 시트 하단 영역 html
  footer: '',

  // 객체 생성 구문
  create: function () {
    var options = this.init;

    options.Events = this.event;
    IBSheet.create({
      id: 'sheet', // 생성할 시트의 id
      el: 'sheetDiv', // 시트를 생성할 Dom 객체 및 id
      options: options, // 생성될 시트의 속성
      data: this.data // 생성될 시트의 정적데이터
    });
    // global 변수 선언
    window.currentPage = -1;
  },

  // 버튼 클릭시 기능 로직
  action: function () {
    if (arguments[0].type === 'checkbox') { // 페이지 네비게이션 표시 선택
      if (samplePageObj.init.Cfg.SearchMode == 1 || samplePageObj.init.Cfg.SearchMode == 4) { // 페이징 조회에서만 페이지네비게이션 표시
        if (arguments[0].checked) { // 페이징 조회에서만 페이지네비게이션 표시
          sheet.InfoRow.Visible = 0; // 페이지네비게이션 표시 안함
          sheet.rerender();

          if (arguments[0].id == 'chk1') {
            document.getElementById('chk2').checked = 0;
            samplePageObj.externalFunction.makePageIndex(sheet.getPageIndex(sheet.getFocusedPage()) + 1); // 페이지 초기화
          } else {
            samplePageObj.externalFunction.jqueryPagination(sheet.getPageIndex(sheet.getFocusedPage()) + 1);
            document.getElementById('chk1').checked = 0;
          }
          document.getElementById('pageNavi').style.display = 'block';
        } else {
          sheet.InfoRow.Visible = 1; // 페이지네비게이션 표시
          sheet.rerender();

          document.getElementById('pageNavi').style.display = 'none';
        }
      }
    } else {
      document.getElementById('pageNavi').style.display = 'none';
      document.getElementById('chk1').checked = 0;
      document.getElementById('chk2').checked = 0;
      sheet.dispose(); //  시트 삭제
      var sMode = arguments[1]; // 1:클라이언트페이징 , 2:서버페이징 , 3:서버스크롤페이징

      samplePageObj.init.Cfg = {
        SearchMode: sMode,
        Alternate: 2,
        InfoRowConfig: ''
      };
      if (sMode === 1) {
        samplePageObj.init.Cfg.PageLength = 50;
      } else if (sMode === 4) {
        samplePageObj.init.Cfg.SortCurrentPage = 1;
        samplePageObj.init.Cfg.PageLength = 50;
      }
      samplePageObj.create(); // 시트 생성
    }
  },
  externalFunction: {
    makePageIndex: function (tp) {
      try {
        if (tp == null) {
          currentPage = -1;

          return;
        }

        if (document.getElementById('pageNavi').firstChild) {
          document.getElementById('pageNavi').removeChild(document.getElementById('pageNavi').firstChild);
        }

        currentPage = tp;
        // 디비전체 데이터 건수를 알아야 한다. 조회 데이터구성 할때 etc 데이터에 TotalRow로 전체 데이터 건수를 가져 온다.
        var sr = sheet.getTotalRowCount(); // 전체 조회 건수
        var page = sheet.PageLength; // 페이지당 레코드 수
        var thispage = tp; // 현재 페이지
        var pagecnt = 5; // 한번에 표시할 페이지 개수
        var lastpage = Math.ceil(sr / page); // 마지막 페이지 인덱스

        var li = null;
        var tt = null;
        var a = null;
        var ul = document.createElement('DIV');

        ul.style.width = sheet.MainTable.clientWidth + 'px';
        ul.style.textAlign = 'center';

        var k = 1;

        if (thispage != 1) {
          li = document.createElement('span');
          li.style.padding = '1px 4px 1px 4px';
          a = document.createElement('a');
          a.style.cursor = 'pointer';
          tt = document.createTextNode('<<');
          samplePageObj.externalFunction.addEventHandler(li, 'click', samplePageObj.externalFunction.pageMove, 1);
          a.appendChild(tt);
          li.appendChild(a);
          ul.appendChild(li);
          li = document.createElement('span');
          li.style.padding = '1px 4px 1px 4px';

          a = document.createElement('a');
          a.style.cursor = 'pointer';
          samplePageObj.externalFunction.addEventHandler(li, 'click', samplePageObj.externalFunction.pageMove, tp - 1);
          tt = document.createTextNode('<');
          a.appendChild(tt);
          li.appendChild(a);
          ul.appendChild(li);
        }

        var sr = (Math.ceil(tp / pagecnt) * pagecnt) - (pagecnt - 1);

        for (var i = sr; i < (sr + pagecnt); i++) {
          if (i <= lastpage) {
            li = document.createElement('span');
            li.style.padding = '1px 4px 1px 4px';
            a = document.createElement('a');

            a.style.cursor = 'pointer';
            tt = document.createTextNode(i);
            samplePageObj.externalFunction.addEventHandler(li, 'click', samplePageObj.externalFunction.pageMove, i);
            if (i == tp) {
              li.style.fontWeight = 'bold';
              li.style.textDecoration = 'underline';
            }
            a.appendChild(tt);
            li.appendChild(a);
            ul.appendChild(li);
          }
        }

        if (thispage < lastpage) {
          a = document.createElement('a');
          a.style.cursor = 'pointer';
          li = document.createElement('span');
          li.style.padding = '1px 4px 1px 4px';
          tt = document.createTextNode('>');
          samplePageObj.externalFunction.addEventHandler(li, 'click', samplePageObj.externalFunction.pageMove, tp + 1);
          a.appendChild(tt);
          li.appendChild(a);
          ul.appendChild(li);
          li = document.createElement('span');
          li.style.padding = '1px 4px 1px 4px';
          tt = document.createTextNode('>>');
          a = document.createElement('a');
          a.style.cursor = 'pointer';
          samplePageObj.externalFunction.addEventHandler(li, 'click', samplePageObj.externalFunction.pageMove, lastpage);
          a.appendChild(tt);
          li.appendChild(a);
          ul.appendChild(li);
        }

        ul.className = 'pageindex';

        document.getElementById('pageNavi').appendChild(ul);
      } catch (ex) {
        alert(ex.message);
      }
    },
    jqueryPagination: function (move) {
      $('#pageNavi').html('');
      $('#pageNavi').removeData('twbs-pagination');

      // set pagination
      $('#pageNavi').twbsPagination({
        totalPages: Math.ceil(sheet.getTotalRowCount() / sheet.PageLength) || 1,
        visiblePages: 5,
        startPage: move || 1,
        initiateStartPageClick: false,
        first: '&laquo;',
        prev: '&lsaquo;',
        next: '&rsaquo;',
        last: '&raquo;',
        paginationClass: 'pagination pagination-sm',
        onPageClick: function (event, page) {
          sheet.goToPageByIndex(page);
        }
      });

      $('#pageNavi > ul').css('width', sheet.MainTable.clientWidth);
      $('#pageNavi > ul').css('text-align', 'center');
    },

    pageMove: function (cPage) {
      sheet.goToPageByIndex(cPage);
    },

    addEventHandler: function (obj, evtName, func, param) {
      if (obj.addEventListener) { // all browsers except IE before version 9
        obj.addEventListener(evtName, function () { func(param); }, false);
      } else if (obj.attachEvent) { // IE before version 9
        obj.attachEvent('on' + evtName, function () { func(param); });
      }
    }
  },
  // event구문
  event: {
    onRenderFirstFinish: function (evtParam) {
      console.log(evtParam.eventName + ' 발생');
      var URL = '/samples/customer/paging.jsp';
      var param = {};

      if (location.href.indexOf('localhost') > -1) {
        URL = '../jsp' + URL;
      } else {
        URL = 'https://api.ibleaders.com/ibsheet/v8' + URL;
      }

      // 시트 최초 생성시 발생 이벤트
      if (evtParam.sheet.SearchMode > 1) { // 서버모듈 조회
        param = {
          url: URL,
          param: 'data=50&total=15000&searchMode=' + evtParam.sheet.SearchMode,
          method: 'POST',
          callback: function (rtn) {
            var rtnData = JSON.parse(rtn.data);

            evtParam.sheet.showMessageTime('<span style=\'color:black\'>조회가 완료되었습니다.<br> 서버모듈 전체 데이터 건수 : ' + rtnData.Total + '</span>', 1000);
          }
        };

        evtParam.sheet.doSearchPaging(param);
      } else { // 클라이언트 조회
        param = {
          url: URL,
          method: 'POST',
          callback: function (rtn) {
            var rtnData = JSON.parse(rtn.data);

            evtParam.sheet.showMessageTime('<span style=\'color:black\'>조회가 완료되었습니다.<br> 클라이언트 전체 데이터 건수 : ' + rtnData.Total + '</span>', 1000);
          }
        };

        evtParam.sheet.doSearch(param);
      }
    },
    onBeforeDataLoad: function (evtParam) {
      // 조회 후 로딩 전 발생 이벤트
      var d = evtParam.data;
      var _data;

      // 서버에서 가져온 데이터를 "데이터" 텝에 넣어준다.
      if (d.length > 20) { // 최대 20개 행만 텝에 넣어 주자(많아지면 화면이 엄청 느려질 수 있음)
        _data = JSON.stringify(d.slice(0, 20), null, 2);
        _data += _data.substring(0, _data.length - 1) + '...\n]';
      } else {
        _data = JSON.stringify(d, null, 2);
      }
      // Not used by jsfiddle.
      try {
        myTabs.contents.items(1).setContents('<pre><code class=\'language-json\'>' + _data + '</code></pre>');
        hljs.initHighlighting.called = false;
        hljs.initHighlighting();
      } catch (e) {
        console.log(e.message);
      }
      // Not used by jsfiddle.
    },
    onAfterGotoPage: function (evtParam) {
      var sheet = evtParam.sheet;
      var page = sheet.getPageIndex(sheet.getFocusedPage()) + 1;

      if (document.getElementById('chk1').checked && currentPage != -1 && currentPage != page) {
        samplePageObj.externalFunction.makePageIndex(page);
      }
    }
  },

  // data
  data: []
};

var sampleBtn = function () {
  var args = Array.prototype.slice.call(arguments, 0);

  samplePageObj.action.apply(null, args);
};
